import React, { useState } from 'react';
import { Shield, Camera, Car, Fingerprint, ChevronDown, Phone, Mail, MapPin, Send } from 'lucide-react';

function App() {
  const [isMenuOpen, setIsMenuOpen] = useState(false);

  return (
    <div className="min-h-screen bg-gray-50">
      {/* Hero Section */}
      <header className="bg-gradient-to-r from-blue-900 to-blue-800 text-white">
        <nav className="container mx-auto px-6 py-4">
          <div className="flex items-center justify-between">
            <div className="flex items-center space-x-2">
              <Shield className="h-8 w-8" />
              <span className="text-2xl font-bold">Startek Seg</span>
            </div>
            <div className="hidden md:flex space-x-8">
              <a href="#servicos" className="hover:text-blue-200 transition">Serviços</a>
              <a href="#portfolio" className="hover:text-blue-200 transition">Portfólio</a>
              <a href="#contato" className="hover:text-blue-200 transition">Contato</a>
            </div>
            <button 
              className="md:hidden"
              onClick={() => setIsMenuOpen(!isMenuOpen)}
            >
              <ChevronDown className={`transform transition-transform ${isMenuOpen ? 'rotate-180' : ''}`} />
            </button>
          </div>
          {isMenuOpen && (
            <div className="md:hidden mt-4 space-y-2">
              <a href="#servicos" className="block hover:text-blue-200 transition py-2">Serviços</a>
              <a href="#portfolio" className="block hover:text-blue-200 transition py-2">Portfólio</a>
              <a href="#contato" className="block hover:text-blue-200 transition py-2">Contato</a>
            </div>
          )}
        </nav>
        <div className="container mx-auto px-6 py-20 text-center">
          <h1 className="text-4xl md:text-6xl font-bold mb-6">
            Segurança Eletrônica para Condomínios
          </h1>
          <p className="text-xl md:text-2xl mb-8 text-blue-100">
            Soluções avançadas para proteger o que é mais importante
          </p>
          <a 
            href="#contato"
            className="bg-white text-blue-900 px-8 py-3 rounded-lg font-semibold hover:bg-blue-50 transition"
          >
            Solicitar Orçamento
          </a>
        </div>
      </header>

      {/* Services Section */}
      <section id="servicos" className="py-20">
        <div className="container mx-auto px-6">
          <h2 className="text-3xl font-bold text-center mb-16 text-blue-900">Nossos Serviços</h2>
          <div className="grid md:grid-cols-2 lg:grid-cols-4 gap-8">
            <ServiceCard 
              icon={<Shield className="h-12 w-12 text-blue-900" />}
              title="Portões Eletrônicos PPA"
              description="Instalação e manutenção de portões eletrônicos da marca PPA com tecnologia de ponta."
            />
            <ServiceCard 
              icon={<Camera className="h-12 w-12 text-blue-900" />}
              title="Câmeras de Segurança"
              description="Sistemas de monitoramento HD com visualização remota e gravação 24/7."
            />
            <ServiceCard 
              icon={<Car className="h-12 w-12 text-blue-900" />}
              title="Controle de Acesso Veicular"
              description="Sistema inteligente para gerenciamento de entrada e saída de veículos."
            />
            <ServiceCard 
              icon={<Fingerprint className="h-12 w-12 text-blue-900" />}
              title="Controle Biométrico"
              description="Tecnologia avançada de reconhecimento facial e biométrico para máxima segurança."
            />
          </div>
        </div>
      </section>

      {/* Portfolio Section */}
      <section id="portfolio" className="py-20 bg-gray-100">
        <div className="container mx-auto px-6">
          <h2 className="text-3xl font-bold text-center mb-16 text-blue-900">Portfólio</h2>
          <div className="grid md:grid-cols-2 gap-8">
            <PortfolioCard 
              image="https://images.unsplash.com/photo-1545324418-cc1a3fa10c00?auto=format&fit=crop&w=800&q=80"
              title="Condomínio Residencial Green Park"
              description="Sistema completo de segurança com câmeras HD e controle biométrico."
            />
            <PortfolioCard 
              image="https://images.unsplash.com/photo-1486406146926-c627a92ad1ab?auto=format&fit=crop&w=800&q=80"
              title="Condomínio Commercial Center"
              description="Automação de portões e controle de acesso veicular integrado."
            />
          </div>
        </div>
      </section>

      {/* Contact Section */}
      <section id="contato" className="py-20">
        <div className="container mx-auto px-6">
          <h2 className="text-3xl font-bold text-center mb-16 text-blue-900">Entre em Contato</h2>
          <div className="grid md:grid-cols-2 gap-12">
            <div className="space-y-8">
              <ContactInfo 
                icon={<Phone className="h-6 w-6" />}
                title="Telefone"
                info="(11) 9999-9999"
              />
              <ContactInfo 
                icon={<Mail className="h-6 w-6" />}
                title="Email"
                info="contato@startekseg.com.br"
              />
              <ContactInfo 
                icon={<MapPin className="h-6 w-6" />}
                title="Endereço"
                info="Av. Principal, 1000 - São Paulo, SP"
              />
            </div>
            <form className="space-y-6">
              <input
                type="text"
                placeholder="Seu Nome"
                className="w-full px-4 py-3 rounded-lg border border-gray-300 focus:border-blue-500 focus:ring-2 focus:ring-blue-200 outline-none transition"
              />
              <input
                type="email"
                placeholder="Seu Email"
                className="w-full px-4 py-3 rounded-lg border border-gray-300 focus:border-blue-500 focus:ring-2 focus:ring-blue-200 outline-none transition"
              />
              <input
                type="tel"
                placeholder="Seu Telefone"
                className="w-full px-4 py-3 rounded-lg border border-gray-300 focus:border-blue-500 focus:ring-2 focus:ring-blue-200 outline-none transition"
              />
              <textarea
                rows={5}
                placeholder="Sua Mensagem"
                className="w-full px-4 py-3 rounded-lg border border-gray-300 focus:border-blue-500 focus:ring-2 focus:ring-blue-200 outline-none transition"
              />
              <button
                type="submit"
                className="w-full bg-blue-900 text-white py-3 rounded-lg font-semibold hover:bg-blue-800 transition flex items-center justify-center space-x-2"
              >
                <span>Enviar Mensagem</span>
                <Send className="h-5 w-5" />
              </button>
            </form>
          </div>
        </div>
      </section>

      {/* Footer */}
      <footer className="bg-blue-900 text-white py-8">
        <div className="container mx-auto px-6 text-center">
          <div className="flex items-center justify-center space-x-2 mb-4">
            <Shield className="h-6 w-6" />
            <span className="text-xl font-bold">Startek Seg</span>
          </div>
          <p className="text-blue-200">© {new Date().getFullYear()} Startek Seg. Todos os direitos reservados.</p>
        </div>
      </footer>
    </div>
  );
}

function ServiceCard({ icon, title, description }: { icon: React.ReactNode; title: string; description: string }) {
  return (
    <div className="bg-white p-8 rounded-xl shadow-lg hover:shadow-xl transition group">
      <div className="mb-6 transform group-hover:scale-110 transition">{icon}</div>
      <h3 className="text-xl font-semibold mb-4 text-blue-900">{title}</h3>
      <p className="text-gray-600">{description}</p>
    </div>
  );
}

function PortfolioCard({ image, title, description }: { image: string; title: string; description: string }) {
  return (
    <div className="bg-white rounded-xl shadow-lg overflow-hidden group">
      <div className="h-64 overflow-hidden">
        <img 
          src={image} 
          alt={title}
          className="w-full h-full object-cover transform group-hover:scale-110 transition duration-500"
        />
      </div>
      <div className="p-6">
        <h3 className="text-xl font-semibold mb-2 text-blue-900">{title}</h3>
        <p className="text-gray-600">{description}</p>
      </div>
    </div>
  );
}

function ContactInfo({ icon, title, info }: { icon: React.ReactNode; title: string; info: string }) {
  return (
    <div className="flex items-start space-x-4">
      <div className="bg-blue-100 p-3 rounded-lg text-blue-900">{icon}</div>
      <div>
        <h3 className="font-semibold text-lg text-blue-900">{title}</h3>
        <p className="text-gray-600">{info}</p>
      </div>
    </div>
  );
}

export default App;